#include <stdlib.h>
#include <stdio.h>

typedef int elem;

typedef struct bucket *list;

struct bucket {
  elem val;
  list next;
};

/*@requires n is well-formed list
  @assigns nothing
  @ensures allocate a bucket with val v and next n
  and return it */
list cons(elem v, list n) {
  list res = malloc(sizeof (struct bucket));
  res->val = v;
  res->next = n;
  return res;
}

/*@ requires l is the address of a well-formed list
  @ assigns *l
  @ ensures add e at the head of *l */
void add(elem e, list *l) {
  *l = cons(e, *l);
}

/*@requires l is a well-formed list
  @assigns all buckets of l
  @ensures free all buckets of l */
void free_list(list l) {
  while (l != NULL) {
    list tmp = l->next;
    free(l);
    l = tmp;
  }
}

void print_list(list l) {
  while (l != NULL) {
    printf("[%d] -> ", l->val);
    l = l->next;
  }
  printf("[]\n");
}

list up_to(int n) {
  list r = NULL;
  for (int i = n; i >= 2; i -= 1)
    add(i, &r);
  return r;
}

void remove_multiples(int n, list *l) {
  while (*l != NULL && (*l)->val % n == 0) 
    *l = (*l)->next;
  if (*l == NULL) return;
  list visit = *l;
  list next = visit->next;
  while (next != NULL) 
    if (next->val % n == 0) {
      visit->next = next->next;
      next = visit->next;
    } else {
      visit = next;
      next = next->next;
    }
}

list primes(int n) {
  list r = up_to(n);
  list visit = r;
  while (visit != NULL) {
    remove_multiples(visit->val, &visit->next);
    visit = visit->next;
  }
  return r;
}

int main() {
  list p = primes(10000);
  print_list(p);
  free_list(p);
  return 0;
}
