#include <stdlib.h>
#include <stdio.h>


typedef int elem;

typedef struct bucket *list;

struct bucket {
  elem val;
  list next;
};

/*@requires n is well-formed list
  @assigns nothing
  @ensures allocate a bucket with val v and next n
  and return it */
list cons(elem v, list n) {
  list res = malloc(sizeof (struct bucket));
  res->val = v;
  res->next = n;
  return res;
}


/*@ requires l is the address of a well-formed list
  @ assigns *l
  @ ensures add e at the head of *l */
void add(elem e, list *l) {
  *l = cons(e, *l);
}

/*@ requires l is the address of a well-formed list
  @ assigns *l
  @ ensures add e at the end of *l */
void add_last(elem x, list *l) {
  list q;
  if (*l == NULL) *l = cons(x, NULL);
  else {
    q = *l;
    while (q->next != NULL)
      q = q->next;
    q->next = cons(x, NULL);
  }
}

/*@ requires l1 and l2 are well-formed lists
  @ assigns some bucket in l1
  @ ensures returns the concatenation of l1 and l2 */
list concat(list l1, list l2) {
  list q;
  if (l1 == NULL) return l2;
  q = l1;
  while (q->next != NULL)
    q = q->next;
  q->next = l2;
  return l1;
}

/*@requires l is a well-formed list
  @assigns nothing
  @ensures returns the number of buckets of the list */
int length(list l) {
  int r = 0;
  while (l != NULL) {
    r += 1;
    l = l->next;
  }
  return r;
}

int main() {
  list l = NULL;
  add(24, &l);
  l = cons(42, l);
  add_last(12, &l);
  l = concat(l,l);
  printf("%d\n", length(l));
  return 0;
}
