#include <stdlib.h>
#include <stdio.h>


typedef int elem;

typedef struct bucket *list;

struct bucket {
  elem val;
  list next;
};

/*@requires n is well-formed list
  @assigns nothing
  @ensures allocate a bucket with val v and next n
  and return it */
list cons(elem v, list n) {
  list res = malloc(sizeof (struct bucket));
  res->val = v;
  res->next = n;
  return res;
}


/*@ requires l is the address of a well-formed list
  @ assigns *l
  @ ensures add e at the head of *l */
void add(list *l, elem e) {
  *l = cons(e, *l);
}

void print_list(list l) {
  while (l != NULL) {
    printf("[%d] -> ", l->val);
    l = l->next;
  }
  printf("[]\n");
}

/*@requires l is a well-formed list
  @assigns nothing
  @ensures free the memory allocated for the buckets of l */
void free_list(list l) {
  while (l != NULL) {
    list n = l->next;
    free(l);
    l = n;
  }
}

void split(list l, list *r1, list *r2) {
  *r1 = malloc(sizeof (struct bucket));
  *r2 = malloc(sizeof (struct bucket));
  if (l == NULL) {
    *r1 = NULL;
    *r2 = NULL;
  } else {
    *r1 = l;
    list d = l;
    while (d->next != NULL && d->next->next != NULL) {
      l = l->next;
      d = d->next->next;
    }
    *r2 = l->next;
    l->next = NULL;
  }
}

void merge(list l1, list l2, list *r) {
  if (l1 == NULL) { *r = l2; return; }
  if (l2 == NULL) { *r = l1; return; }
  list res = malloc(sizeof (struct bucket));
  list other = malloc(sizeof (struct bucket));
  if (l1->val < l2->val) {
    *r = l1;
    res = l1;
    other = l2;
  } else {
    *r = l2;
    res = l2;
    other = l1;
  }
  /*@ loop invariant res != NULL && other != NULL */
  while (res->next != NULL) 
    if (res->next->val <= other->val)
      res = res->next;
    else {
      list tmp = res->next;
      res->next = other;
      res = other;
      other = tmp;
    }
  res->next = other;
}
      
void merge_sort(list *l) {
  if (*l == NULL || (*l)->next == NULL) return;
  list l1, l2;
  split(*l, &l1, &l2);
  merge_sort(&l1);
  merge_sort(&l2);
  merge(l1, l2, l);
}

int main() {
  list l = NULL;
  add(&l, 3);
  add(&l, 1);
  add(&l, 9);
  add(&l, 4);
  add(&l, 7);
  add(&l, 6);
  add(&l, 5);
  add(&l, 2);
  add(&l, 8);
  add(&l, 5);
  add(&l, 1);
  print_list(l);
  merge_sort(&l);
  print_list(l);
  free_list(l);
  return 0;
}
						  

  
  


  
