#include <stdlib.h>
#include <stdio.h>

/*@ requires i >= 0, j >= 0, i and j are strictly
  less than the size of t
  assigns t[i] and t[j]
  ensures swap the content of t at indices i and j */
void swap(int t[], int i, int j) {
  int tmp = t[i];
  t[i] = t[j];
  t[j] = tmp;
}


/*@requires a valid address, *a array of size n
  @assigns *a and its content
  @ensures *a is sorted */
void sort(int **a, int n) {
  int *tmp = malloc(n * sizeof (int));
  for (int i = 0; i < n; i += 1) {
    int j = i;
    tmp[i] = (*a)[i];
    while (j > 0 && tmp[j] < tmp[j - 1]) {
      swap(tmp, j, j - 1);
      j -= 1;
    }
  }
  *a = tmp;
}

int main() {
  int *r = malloc(10 * sizeof (int));
  for (int i = 0; i < 10; i += 1)
    r[i] = rand() % 10;
  for (int i = 0; i < 10; i += 1)
    printf("%3d", r[i]);
  printf("\n");
  sort(&r, 10);
  for (int i = 0; i < 10; i += 1)
    printf("%3d", r[i]);
  printf("\n");
  free(r);
  return 0;
}
  
