#include <stdio.h>

struct stack {
  int top;
  int content[256];
};

typedef struct stack stack;

void init(stack *s) {
  s->top = -1;
}

int is_empty(stack *s) {
  return s->top < 0;
}

void push(stack *s, int e) {
  s->content[s->top++] = e;
}

int pop(stack *s) {
  return s->content[s->top--];
}

int main() {
  stack s;
  init(&s);
  push(&s, 42);
  push(&s, 3);
  push(&s, 12);
  while (! is_empty(&s)) 
    printf("%d\n", pop(&s));
  return 0;
}
